/**
 * Copyright (C) 2012, BMW AG
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Christian Mueller, christian.linke@bmw.de BMW 2011,2012
 *
 * \file
 * For further information see http://www.genivi.org/.
 *
 * THIS CODE HAS BEEN GENERATED BY ENTERPRISE ARCHITECT GENIVI MODEL. PLEASE CHANGE ONLY IN ENTERPRISE ARCHITECT AND GENERATE AGAIN
 */
#if !defined(EA_95D3C82A_0870_4fe0_A468_5AFF99D80A26__INCLUDED_)
#define EA_95D3C82A_0870_4fe0_A468_5AFF99D80A26__INCLUDED_

#include <stdint.h>
#include <string>
#include <vector>


namespace am {
/**
 * a domain ID
 */
typedef uint16_t am_domainID_t;

/**
 * a crossfader ID
 */
typedef uint16_t am_crossfaderID_t;
/**
 * a connection ID
 */
typedef uint16_t am_connectionID_t;
/**
 * a source ID
 */
  typedef uint16_t am_sourceID_t;

  /**
   * a sink ID
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  typedef uint16_t am_sinkID_t;

/**
 * a converter ID
 */
typedef uint16_t am_converterID_t;
/**
 * a gateway ID
 */
  typedef uint16_t am_gatewayID_t;

/**
 * a mainConnection ID
 */
  typedef uint16_t am_mainConnectionID_t;

  /**
   * speed
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  typedef uint16_t am_speed_t;

  /**
   * The unit is 0.1 db steps,The smallest value -3000 (=AM_MUTE). The minimum and maximum can be limited by actual project.
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
typedef int16_t am_volume_t;
static const am_volume_t AM_MUTE = -3000;

/**
 * This is the volume presented on the command interface. It is in the duty of the
 * Controller to change the volumes given here into meaningful values on the
 * routing interface.
 * The range of this type is customer specific.
 */
  typedef int16_t am_mainVolume_t;

  /**
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  typedef uint16_t am_sourceClass_t;

  /**
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  typedef uint16_t am_sinkClass_t;

  /**
   * time in ms!
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  typedef uint16_t am_time_t;

  /**
   * offset time that is introduced in milli seconds.
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  typedef int16_t am_timeSync_t;

/**
 * This type gives the information about reason for reason for Source/Sink change
 */
typedef uint16_t am_CustomAvailabilityReason_t;
static const am_CustomAvailabilityReason_t AR_UNKNOWN = 0;
/** new media was entered  */
static const am_CustomAvailabilityReason_t AR_GENIVI_NEWMEDIA = 1;
/** same media was entered */
static const am_CustomAvailabilityReason_t AR_GENIVI_SAMEMEDIA = 2;
/** there is no media or media is removed */
static const am_CustomAvailabilityReason_t AR_GENIVI_NOMEDIA = 3;
/** there was a temperature event */
static const am_CustomAvailabilityReason_t AR_GENIVI_TEMPERATURE = 4;
/** there was a voltage event */
static const am_CustomAvailabilityReason_t AR_GENIVI_VOLTAGE = 5;
/** fatal errors on reading or accessing media */
static const am_CustomAvailabilityReason_t AR_GENIVI_ERRORMEDIA = 6;
/** the availability changed because of no media content */
static const am_CustomAvailabilityReason_t AR_GENIVI_MEDIA_NOCONTENT = 7;
/** the availability changed because of over current */
static const am_CustomAvailabilityReason_t AR_GENIVI_OVER_CURRENT = 8;
/** the availability changed because of internal disconnect */
static const am_CustomAvailabilityReason_t AR_GENIVI_INTERNAL_DISCONNECT = 9;
/** the availability MAX */
static const am_CustomAvailabilityReason_t AR_MAX = 10;


/**
 * This is a custom specific identifier of property. It can be used to
 * differentiate between interrupt source/sink, main source/sink, etc.
 */
typedef uint16_t am_CustomClassProperty_t;
static const am_CustomClassProperty_t CP_UNKNOWN = 0;
static const am_CustomClassProperty_t CP_GENIVI_SOURCE_TYPE = 1;
static const am_CustomClassProperty_t CP_GENIVI_SINK_TYPE = 2;
/**
 * This type classifies the format in which data is exchanged within a connection.
 * The type itself is project specific although there are some standard formats
 * defined.
 */
typedef uint16_t am_CustomConnectionFormat_t;
static const am_CustomConnectionFormat_t CF_UNKNOWN = 0;
static const am_CustomConnectionFormat_t CF_MONO = 1;
static const am_CustomConnectionFormat_t CF_STEREO = 2;
static const am_CustomConnectionFormat_t CF_ANALOG = 3;
static const am_CustomConnectionFormat_t CF_AUTO = 4;
static const am_CustomConnectionFormat_t CF_MAX = 5;

/**
 * Here are all SoundProperties that can be set via the CommandInterface.
 * This type is product specific and can be changed or extended.
 */
typedef uint16_t am_CustomMainSoundPropertyType_t;

static const am_CustomMainSoundPropertyType_t MSP_UNKNOWN = 0;
/** Bass setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BASS = 1;
/** Bass setting with relative steps. Modifies property MSP_SOUND_BASS */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BASS_RELATIVE = 2;
/** Middle setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_MIDDLE = 3;
/** Middle setting with relative steps. Modifies property MSP_SOUND_MIDDLE */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_MIDDLE_RELATIVE = 4;
/** Treble setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_TREBLE = 5;
/** Treble setting with relative steps. Modifies property MSP_SOUND_TREBLE */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_TREBLE_RELATIVE = 6;
/** Loudness setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_LOUDNESS = 7;
/** Loudness setting with relative steps. Modifies property MSP_SOUND_LOUDNESS */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_LOUDNESS_RELATIVE = 8;
/** Balance setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BALANCE = 9;
/** Balance setting with relative steps. Modifies property MSP_SOUND_BALANCE */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BALANCE_RELATIVE = 10;
/** Fader setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_FADER = 11;
/** Fader setting with relative steps. Modifies property MSP_SOUND_FADER */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_FADER_RELATIVE = 12;
/** Dynamic compression. Possible values defined as AM_MSP_DYN_COMPRESSION_**/
static const am_CustomMainSoundPropertyType_t MSP_SOUND_DYN_COMPRESSION = 13;
/** Equalizer Presets. Possible values defined as AM_MSP_EQU_PRESET_*
 ** ADR3 configuration matches number to name in DpInit_PreMix.h,
 ** generated by ADR3_ParaConfig.xls **/
static const am_CustomMainSoundPropertyType_t MSP_EQUALIZER_PRESET = 14;
/** Speed dependent volume: Possible values defined as AM_MSP_SDV_ **/
static const am_CustomMainSoundPropertyType_t MSP_SPEED_DEPENDENT_VOLUME = 15;
/** Microphone connection status. Possible values defined as */
static const am_CustomMainSoundPropertyType_t MSP_MIC_STATUS_CONNECTION = 16;
/** Microphone level. Possible values defined as */
static const am_CustomMainSoundPropertyType_t MSP_MIC_STATUS_LEVEL = 17;
/** Sound optimization. Possible values defined as AM_MSP_SND_OPTI_ **/
static const am_CustomMainSoundPropertyType_t MSP_SOUND_OPTIMIZATION = 18;
/** Room effect. Possible values defined as AM_MSP_SND_ROOM_EFFECT_ **/
static const am_CustomMainSoundPropertyType_t MSP_SOUND_ROOM_EFFECT = 19;
/** Aux In level. Possible values defined as AM_MSP_LVL_AUX_IN_ **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_AUX_IN = 20;
/** Beep level. Possible values defined as AM_MSP_LVL_BEEP_ **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_BEEP = 21;
/** Center speaker level. Possible values defined as **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_CENTER = 22;
/** Subwoofer level. Possible values defined as **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_SUBWOOFER = 23;
/** Surround Setting. Possible values defined as **/
static const am_CustomMainSoundPropertyType_t MSP_SETTING_SURROUND = 24;
/** Audio Mode **/
static const am_CustomMainSoundPropertyType_t MSP_MODE_AUDIO = 25;
/** Volume for entertainment sources **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_ENTERTAINMENT = 26;
/** Volume for Phone source **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE = 27;
/** Volume for ONVOL **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_ONVOL = 28;
/** Volume for TA sources **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_TA = 29;
/** Volume for Beep tone **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_BEEP = 30;
/** PDC Attenuation level. Possible values defined as AM_MSP_PDC_ATTENUATION_ **/
static const am_CustomMainSoundPropertyType_t MSP_PDC_ATTENUATION_LEVEL = 31;
/** BTAudio In level. Possible values defined as AM_MSP_LVL_BTAUDIO_IN_ **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_BTAUDIO_IN = 32;
/** Gala Gain status **/
static const am_CustomMainSoundPropertyType_t MSP_GALA_GAIN = 33;
/** PDC status. Possible values defined as AM_MSP_PDC_COMMAND_ **/
static const am_CustomMainSoundPropertyType_t MSP_PDC_ACTIVE = 34;
/** Volume lock status **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_LOCK = 35;
/** System Mute status. Possible values defined as AM_MSP_SYSTEM_MUTE_ **/
static const am_CustomMainSoundPropertyType_t MSP_SYSTEM_MUTE = 36;
/** Volume for Navigation **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_NAVIGATION = 37;
/** Volume for SDS **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_SDS = 38;
/** Volume for Ringtone **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_RINGTONE = 39;
/** System Property for ACC Off/On **/
static const am_CustomMainSoundPropertyType_t MSP_AUDIO_OFF_MUTE = 40;
/** Sound Property to report the source for which the volume will be valid **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_SOURCE = 41;
/** Center speaker level with relative steps. Modifies property MSP_LEVEL_CENTER **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_CENTER_RELATIVE = 42;
/** SubWoofer level with relative steps. Modifies property MSP_LEVEL_SUBWOOFER **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_SUBWOOFER_RELATIVE = 43;
/** Children sleep mode **/
static const am_CustomMainSoundPropertyType_t MSP_CHILDREN_SLEEP_MODE = 44;
/** FM Enhancer **/
static const am_CustomMainSoundPropertyType_t  MSP_FM_ENHANCER = 45;
/** ESE Sound Type **/
static const am_CustomMainSoundPropertyType_t  MSP_ESE_SOUND_TYPE = 46;
/** ESE Volume **/
static const am_CustomMainSoundPropertyType_t MSP_ESE_VOLUME = 47;
/** RSoundOnOff **/
static const am_CustomMainSoundPropertyType_t   MSP_R_SOUND_ON_OFF = 48;
/** RSoundSoundType **/
static const am_CustomMainSoundPropertyType_t   MSP_R_SOUND_SOUND_TYPE = 49;
/** RSoundSoundVolume **/
static const am_CustomMainSoundPropertyType_t   MSP_R_SOUND_VOLUME = 50;
/** Property for setting the audio mode in HMI based on Arkamys Library **/
static const am_CustomMainSoundPropertyType_t   MSP_ARKAMYS_AUDIO_MODE = 51;
/** This property can be used to set/get the user volume of UPA **/
static const am_CustomMainSoundPropertyType_t   MSP_ADAS_PARK_ASSISTANT_VOLUME = 52;
/** This property can be used to set/get the UPA Temporary Mute State **/
static const am_CustomMainSoundPropertyType_t   MSP_ADAS_UPA_MUTE = 53;
/** Property for setting the Geometry mode in HMI **/
static const am_CustomMainSoundPropertyType_t   MSP_GEOMETRY_MODE = 54;
/**  Property for setting the automatic gain control in HMI based on Arkamys Library **/
static const am_CustomMainSoundPropertyType_t MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL = 55;
/** Property that can be used to set/get the user volume of LDW/LKA **/
static const am_CustomMainSoundPropertyType_t   MSP_ADAS_LDW_USER_VOLUME = 56;
/** Property to update status of Amplifier Availability Function status **/
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAILABILITY_FUNCTION_STATUS = 57;
/** RSoundActivation **/
static const am_CustomMainSoundPropertyType_t MSP_R_SOUND_ACTIVATE = 58;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPVOLUME=59;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPVOLUME_RELATIVE=60;

/** MCAN BOSE Amplifier properties **/
static const am_CustomMainSoundPropertyType_t MSP_BOSE_AUDIO_PILOT=61;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_CENTER_POINT=62;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_SURROUND_VOLUME=63;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_DRIVER_AUDIO_STAGE=64;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_REARSEAT_AUDIO_STAGE=65;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_ANC_ASC_ACTIVETEST=66;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_ANC_SETTING=67;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_ASC_SETTING=68;
/** SCENE Recorder Sound Notification **/
static const am_CustomMainSoundPropertyType_t MSP_SR_SOUND_NOTIFICATION=69;
static const am_CustomMainSoundPropertyType_t MSP_ESE_SETTING=70;
static const am_CustomMainSoundPropertyType_t MSP_AUDIO_PILOT_INTENSITY=71;
 /*Extension of ampavail */
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_BASS                = 72;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_MIDDLE              = 73;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_TREBLE              = 74;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_BALANCE             = 75;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_FADER               = 76;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_AUDIO_PILOT         = 77;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_GALA                = 78;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SURROUNDMODE        = 79;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SUBWOOFER           = 80;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_STAGING             = 81;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ROOMEFFECT          = 82;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_LOUDNESS            = 83;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_AGC                 = 84;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_AMPDOWNMIX          = 85;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SURROUND_VOLUME     = 86;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_DRIVER_AUDIO_STAGE  = 87;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_REARSEAT_AUDIO_STAGE= 88;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ANC                 = 89;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ASC                 = 90;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SOUNDAMBIANCE       = 91;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ESE                 = 92;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPMINVOLUME           = 93;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPMINVOLUME_RELATIVE  = 94;
static const am_CustomMainSoundPropertyType_t MSP_MAX = 95;



/* VVD MSP VALUES */
/**
 * Value for MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL
 * @author Vyankatesh VD
 * @created 17-Sep-2016
 */
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_OFF  ((int16_t) 0)
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_ON   ((int16_t) 1)

/* VVD MSP VALUES */
/**
 * Value for MSP_AUDIO_PILOT_INTENSITY
 * @author Swati N
 * @created 17-Feb-2018
 */
#define MSP_AUDIO_PILOT_INTENSITY_LOW      ((int16_t) 1)
#define MSP_AUDIO_PILOT_INTENSITY_MEDIUM   ((int16_t) 2)
#define MSP_AUDIO_PILOT_INTENSITY_HIGH     ((int16_t) 3)

/* VVD MSP_ESE_SETTING VALUES */
/**
 * Value for MSP_ESE_SETTING
 * @author Swati N
 * @created 16-Feb-2018
 */
#define MSP_ESE_SETTING_ON                 ((int16_t) 1)
#define MSP_ESE_SETTING_OFF                ((int16_t) 0)
/* VVD MSP_BOSE_ANC_SETTING VALUES */
/**
 * Value for MSP_BOSE_ANC_SETTING
 * @author Swati N
 * @created 16-Feb-2018
 */
#define MSP_BOSE_ANC_SETTING_ON                 ((int16_t) 1)
#define MSP_BOSE_ANC_SETTING_OFF                ((int16_t) 0)
/*
 * Values for System property 'SYP_ESE_DRIVE_MODE'
 */
#define AM_SYP_ESE_DRIVE_MODE_ECO      ((int16_t) 0)
#define AM_SYP_ESE_DRIVE_MODE_COMFORT    ((int16_t) 1)
#define AM_SYP_ESE_DRIVE_MODE_NORMAL    ((int16_t) 2)
#define AM_SYP_ESE_DRIVE_MODE_DYNAMIC    ((int16_t) 3)
#define AM_SYP_ESE_DRIVE_MODE_PERSO    ((int16_t) 4)

/*
 * Values for Sink property 'MSP_ESE_SOUND_TYPE'
 * Below values are defined only for RN-IVI project
 * which can vary for other projects
 */
#define AM_MSP_ESE_SOUND_TYPE_NEUTRAL      ((int16_t) 1)
#define AM_MSP_ESE_SOUND_TYPE_SOUND_1      ((int16_t) 2)
#define AM_MSP_ESE_SOUND_TYPE_SOUND_2      ((int16_t) 3)

/*
 * Values for Sink property 'MSP_ESE_SOUND_VOLUME'
 * Below values are defined only for RN-IVI project
 * which can vary for other projects
 */
#define AM_MSP_ESE_VOLUME_OFF      ((int16_t) 1)
#define AM_MSP_ESE_VOLUME_LOW      ((int16_t) 2)
#define AM_MSP_ESE_VOLUME_HIGH    ((int16_t) 3)

/*
 * Values for Sink property 'MSP_R_SOUND_ON_OFF'
 */
#define AM_MSP_R_SOUND_OFF      ((int16_t) 0)
#define AM_MSP_R_SOUND_ON          ((int16_t) 1)

/*
 * Values for Sink property 'MSP_R_SOUND_ACTIVATE'
 */
#define MSP_R_SOUND_ACTIVATE_OFF  ((int16_t) 0)
#define MSP_R_SOUND_ACTIVATE_ON    ((int16_t) 1)
/*
 * Values for Sink property 'MSP_R_SOUND_SOUND_TYPE'
 */
#define AM_MSP_R_SOUND_SOUND_TYPE_1      ((int16_t) 1)
#define AM_MSP_R_SOUND_SOUND_TYPE_2      ((int16_t) 2)
#define AM_MSP_R_SOUND_SOUND_TYPE_3      ((int16_t) 3)
#define AM_MSP_R_SOUND_SOUND_TYPE_4      ((int16_t) 4)
#define AM_MSP_R_SOUND_SOUND_TYPE_5      ((int16_t) 5)
#define AM_MSP_R_SOUND_SOUND_TYPE_6      ((int16_t) 6)

/*
 * Values for Sink property 'MSP_R_SOUND_VOLUME'
 */
#define MSP_R_SOUND_VOLUME_0    ((int16_t) 0)
#define MSP_R_SOUND_VOLUME_1    ((int16_t) 1)
#define MSP_R_SOUND_VOLUME_2    ((int16_t) 2)
#define MSP_R_SOUND_VOLUME_3    ((int16_t) 3)
#define MSP_R_SOUND_VOLUME_4    ((int16_t) 4)
#define MSP_R_SOUND_VOLUME_5    ((int16_t) 5)
#define MSP_R_SOUND_VOLUME_6    ((int16_t) 6)
#define MSP_R_SOUND_VOLUME_7    ((int16_t) 7)
#define MSP_R_SOUND_VOLUME_8    ((int16_t) 8)
#define MSP_R_SOUND_VOLUME_9    ((int16_t) 9)
#define MSP_R_SOUND_VOLUME_10    ((int16_t) 10)
#define MSP_R_SOUND_VOLUME_11    ((int16_t) 11)
#define MSP_R_SOUND_VOLUME_12    ((int16_t) 12)
#define MSP_R_SOUND_VOLUME_13    ((int16_t) 13)
#define MSP_R_SOUND_VOLUME_14    ((int16_t) 14)
#define MSP_R_SOUND_VOLUME_15    ((int16_t) 15)

/**
 * MSP_SOUND_DYN_COMPRESSION values
 */
#define AM_MSP_DYN_COMPRESSION_OFF  ((int16_t) 0)
#define AM_MSP_DYN_COMPRESSION_ON   ((int16_t) 1)


/**
 * MSP_EQUALIZER_PRESET values
 * ADR3 configuration matches number to name in DpInit_PreMix.h,
 * generated by ADR3_ParaConfig.xls
 */
#define AM_MSP_EQU_PRESET_0      ((int16_t) 0)
#define AM_MSP_EQU_PRESET_1      ((int16_t) 1)
#define AM_MSP_EQU_PRESET_2      ((int16_t) 2)
#define AM_MSP_EQU_PRESET_3      ((int16_t) 3)
#define AM_MSP_EQU_PRESET_4      ((int16_t) 4)
#define AM_MSP_EQU_PRESET_5      ((int16_t) 5)
#define AM_MSP_EQU_PRESET_NOT_DEF  ((int16_t) 255)
/**
 * MSP_SPEED_DEPENDENT_VOLUME values
 */
#define AM_MSP_SDV_OFF      ((int16_t) 0)
#define AM_MSP_SDV_LEVEL_1  ((int16_t) 1)
#define AM_MSP_SDV_LEVEL_2  ((int16_t) 2)
#define AM_MSP_SDV_LEVEL_3  ((int16_t) 3)
#define AM_MSP_SDV_LEVEL_4  ((int16_t) 4)
#define AM_MSP_SDV_LEVEL_5  ((int16_t) 5)
#define AM_MSP_SDV_LEVEL_6  ((int16_t) 6)
#define AM_MSP_SDV_LEVEL_7  ((int16_t) 7)
#define AM_MSP_SDV_NOT_DEF  ((int16_t) 255)

/**
 * MSP_MIC_STATUS_CONNECTION values
 */
/* Values yet to be defined */


/**
 * MSP_MIC_STATUS_LEVEL values
 */
/* Values yet to be defined */


/**
 * MSP_SOUND_OPTIMIZATION values
 */
#define AM_MSP_SND_OPTI_OFF      ((int16_t) 0)
#define AM_MSP_SND_OPTI_LEFT     ((int16_t) 1)
#define AM_MSP_SND_OPTI_RIGHT    ((int16_t) 2)
#define AM_MSP_SND_OPTI_ALL      ((int16_t) 3)
#define AM_MSP_SND_OPTI_DRIVER   ((int16_t) 4)
#define AM_MSP_SND_OPTI_FRONT    ((int16_t) 5)
#define AM_MSP_SND_OPTI_NOT_DEF  ((int16_t) 255)


/**
 * MSP_SOUND_ROOM_EFFECT values
 */
#define AM_MSP_SND_ROOM_EFFECT_LEVEL0  ((int16_t) 0)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL1  ((int16_t) 1)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL2  ((int16_t) 2)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL3  ((int16_t) 3)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL4  ((int16_t) 4)

/**
 * MSP_LEVEL_AUX_IN values
 */
#define AM_MSP_LVL_AUX_IN_LEVEL1      ((int16_t) 1)
#define AM_MSP_LVL_AUX_IN_LEVEL2      ((int16_t) 2)
#define AM_MSP_LVL_AUX_IN_LEVEL3      ((int16_t) 3)
#define AM_MSP_LVL_AUX_IN_LEVEL_NOT_DEF    ((int16_t) 255)
/**
* MSP_LEVEL_BEEP values
*/
#define AM_MSP_LVL_BEEP_LEVEL1      ((int16_t) 1)
#define AM_MSP_LVL_BEEP_LEVEL2      ((int16_t) 2)
#define AM_MSP_LVL_BEEP_LEVEL3      ((int16_t) 3)


/**
 * MSP_LEVEL_CENTER values
 */
/* Values yet to be defined */


/**
 * MSP_LEVEL_SUBWOOFER values
 */


/**
 * MSP_SETTING_SURROUND values
 */
/* Values yet to be defined */


/**
 * MSP_MODE_AUDIO values
 */
#define AM_MSP_MODE_AUDIO_NORMAL      ((int16_t) 0)
#define AM_MSP_MODE_AUDIO_LINEAR      ((int16_t) 1)

/**
 * MSP_PDC_ATTENUATION_LEVEL values
 */
#define AM_MSP_PDC_ATTENUATION_OFF       ((int16_t) 0)
#define AM_MSP_PDC_ATTENUATION_LIGHTER   ((int16_t) 1)
#define AM_MSP_PDC_ATTENUATION_LIGHT     ((int16_t) 2)
#define AM_MSP_PDC_ATTENUATION_MEDIUM    ((int16_t) 3)
#define AM_MSP_PDC_ATTENUATION_STRONG    ((int16_t) 4)
#define AM_MSP_PDC_ATTENUATION_STRONGER  ((int16_t) 5)
#define AM_MSP_PDC_ATTENUATION_MAX       ((int16_t) 6)

/**
 * MSP_LEVEL_BTAUDIO_IN values
 */
#define AM_MSP_LVL_BTAUDIO_IN_LEVEL1   ((int16_t) 0)
#define AM_MSP_LVL_BTAUDIO_IN_LEVEL2   ((int16_t) 1)
#define AM_MSP_LVL_BTAUDIO_IN_LEVEL3   ((int16_t) 2)

/**
 * MSP_PDC_ACTIVE values
 */
#define AM_MSP_PDC_COMMAND_START   ((int16_t) 1)
#define AM_MSP_PDC_COMMAND_STOP    ((int16_t) 2)
#define AM_MSP_PDC_COMMAND_BREAK   ((int16_t) 3)
#define AM_MSP_PDC_COMMAND_NOT_DEF ((int16_t) 255)


/**
 * MSP_SYSTEM_MUTE values
 */
#define AM_MSP_SYSTEM_MUTE_OFF  ((int16_t) 0)
#define AM_MSP_SYSTEM_MUTE_ON   ((int16_t) 1)

/**
MSP_CLILDREN_SLEEP_MODE
**/
#define AM_MSP_AUDIO_OFF_MUTE_UNDEF  ((int16_t) -1)
#define MSP_CHILDREN_SLEEP_MODE_OFF  ((int16_t) 0)
#define MSP_CHILDREN_SLEEP_MODE_ON   ((int16_t) 1)

/**
 * MSP_AUDIO_OFF_MUTE values
 */
#define AM_MSP_AUDIO_OFF_MUTE_OFF  ((int16_t) 0)
#define AM_MSP_AUDIO_OFF_MUTE_ON   ((int16_t) 1)

/*
 * MSP_ARKAMYS_AUDIO_MODE values (Property for setting the audio mode in HMI based on Arkamys Library.)
 */
#define AM_MSP_ARKAMYS_AUDIO_MODE_BYPASS      ((int16_t) 1)
#define AM_MSP_ARKAMYS_AUDIO_MODE_CLASSIC      ((int16_t) 2)
#define AM_MSP_ARKAMYS_AUDIO_MODE_AUDITORIUM    ((int16_t) 3)
#define AM_MSP_ARKAMYS_AUDIO_MODE_PREMIUM_1    ((int16_t) 4)
#define AM_MSP_ARKAMYS_AUDIO_MODE_PREMIUM_2    ((int16_t) 5)
#define AM_MSP_ARKAMYS_AUDIO_MODE_NOT_DEF      ((int16_t) 255)

/*
 * Values for Sink property 'MSP_ADAS_PARK_ASSISTANT_VOLUME'
 */
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_NO_SOUND    ((int16_t) 0)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_1      ((int16_t) 1)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_2      ((int16_t) 2)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_3      ((int16_t) 3)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_4      ((int16_t) 4)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_5      ((int16_t) 5)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_NOT_DEF   ((int16_t) 255)

/*
 * Values for Sink property 'MSP_ADAS_UPA_MUTE'
 */
#define  MSP_ADAS_UPA_MUTE_OFF      ((int16_t) 0)
#define  MSP_ADAS_UPA_MUTE_ON      ((int16_t) 1)
#define  MSP_ADAS_UPA_MUTE_NOT_DEF    ((int16_t) 255)

/*
 * Values for Sink property 'MSP_ADAS_LDW_USER_VOLUME'
 */
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_INVALID     ((int16_t) 0)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_1      ((int16_t) 1)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_2      ((int16_t) 2)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_3      ((int16_t) 3)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_4      ((int16_t) 4)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_5      ((int16_t) 5)

/*
 * Values for Sink property 'MSP_GEOMETRY_MODE'
 */
#define  AM_MSP_GEOMETRY_MODE_MANUAL      ((int16_t) 0)
#define  AM_MSP_GEOMETRY_MODE_CHILDREN_SLEEP    ((int16_t) 1)
#define  AM_MSP_GEOMETRY_MODE_ALL_CAR      ((int16_t) 2)
#define  AM_MSP_GEOMETRY_MODE_NOT_DEF      ((int16_t) 255)

/**
 * Value for MSP_FM_ENHANCER
 * @author Vyankatesh VD
 * @created 15-Dec-2015 04:44:00 pm
 */
#define AM_MSP_FM_ENHANCER_OFF  ((int16_t) 0)
#define AM_MSP_FM_ENHANCER_ON   ((int16_t) 1)
/**
 * Value for MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL
 * @author Vyankatesh VD
 * @created 17-Sep-2016
 */
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_OFF  ((int16_t) 0)
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_ON   ((int16_t) 1)

/*
 * Values for property MSP_BOSE_AUDIO_PILOT
 */
#define MSP_BOSE_AUDIO_PILOT_OFF  ((int16_t) 0)
#define MSP_BOSE_AUDIO_PILOT_ON    ((int16_t) 1)

/*
 * Values for property MSP_BOSE_ANC_ASC_ACTIVETEST
 */
#define MSP_BOSE_ANC_ASC_ACTIVETEST_OFF  ((int16_t) 0)
#define MSP_BOSE_ANC_ASC_ACTIVETEST_ON    ((int16_t) 1)

/*
 * Values for property MSP_BOSE_ANC_ASC_SETTING
 */
#define MSP_BOSE_ANC_ASC_SETTING_UNAVAILABLE  ((int16_t) 15)
#define MSP_BOSE_ANC_ASC_SETTING_ENABLE    ((int16_t) 1)
#define MSP_BOSE_ANC_ASC_SETTING_DISABLE    ((int16_t) 0)

/*
 * Values for property MSP_BOSE_CENTER_POINT
 */
#define MSP_BOSE_CENTER_POINT_OFF  ((int16_t) 0)
#define MSP_BOSE_CENTER_POINT_ON  ((int16_t) 1)

/*
 * Values for property MSP_BOSE_SURROUND_VOLUME
 */
#define MSP_BOSE_SURROUND_VOLUME_1  ((int16_t) 1)
#define MSP_BOSE_SURROUND_VOLUME_2  ((int16_t) 2)
#define MSP_BOSE_SURROUND_VOLUME_3  ((int16_t) 3)
#define MSP_BOSE_SURROUND_VOLUME_4  ((int16_t) 4)
#define MSP_BOSE_SURROUND_VOLUME_5  ((int16_t) 5)
#define MSP_BOSE_SURROUND_VOLUME_6  ((int16_t) 6)

/*
 * Values for property MSP_BOSE_DRIVER_AUDIO_STAGE
 */
#define MSP_BOSE_DRIVER_AUDIO_STAGE_OFF  ((int16_t) 0)
#define MSP_BOSE_DRIVER_AUDIO_STAGE_ON  ((int16_t) 1)

/*
 * Values for property MSP_BOSE_REARSEAT_AUDIO_STAGE
 */
#define MSP_BOSE_REARSEAT_AUDIO_STAGE_OFF  ((int16_t) 0)
#define MSP_BOSE_REARSEAT_AUDIO_STAGE_ON  ((int16_t) 1)

/*
 * Values for property MSP_SR_SOUND_NOTIFICATION
 */
#define MSP_SR_SOUND_NOTIFICATION_OFF   ((int16_t) 0)
#define MSP_SR_SOUND_NOTIFICATION_ON    ((int16_t) 1)


/*
 * Property to update status of Amplifier Availability status
 */
//MSP_AMP_AVAILABILITY_STATUS = 56,
enum am_AmpAvailabilityFunctionStatus_e
{
 /* Valid set , but since update to HMI is int16_t type need to check*/

  MSP_AMP_AVAILABILITY_AUDIO_PILOT         = 0x00001,
  MSP_AMP_AVAILABILITY_BALANCE             = 0x00002,
  MSP_AMP_AVAILABILITY_BASS                = 0x00004,
  MSP_AMP_AVAILABILITY_FADER               = 0x00008,
  MSP_AMP_AVAILABILITY_GALA                = 0x00010,
  MSP_AMP_AVAILABILITY_MIDDLE              = 0x00020,
  MSP_AMP_AVAILABILITY_SURROUNDMODE        = 0x00040,
  MSP_AMP_AVAILABILITY_TREBLE              = 0x00080,
  MSP_AMP_AVAILABILITY_AMPDOWNMIX          = 0x00100,
  MSP_AMP_AVAILABILITY_SURROUND_VOLUME     = 0x00200,
  MSP_AMP_AVAILABILITY_DRIVER_AUDIO_STAGE  = 0x00400,
  MSP_AMP_AVAILABILITY_REARSEAT_AUDIO_STAGE    = 0x00800,
  MSP_AMP_AVAILABILITY_ANC                     = 0x01000,
  MSP_AMP_AVAILABILITY_ASC                     = 0x02000,
  MSP_AMP_AVAILABILITY_ROOMEFFECT              = 0x04000,
  MSP_AMP_AVAILABILITY_SOUNDAMBIANCE           = 0x08000
};

/**
 * The notification types are project specific.
 */
typedef uint16_t am_CustomNotificationType_t;
static const am_CustomNotificationType_t NT_UNKNOWN = 0;

/**
 * The given ramp types here are just examples. For products, different ramp types
 * can be defined here. It is in the responsibility of the product to make sure
 * that the routing plugins are aware of the ramp types used.
 */
typedef uint16_t am_CustomRampType_t;
static const am_CustomRampType_t RAMP_UNKNOWN = 0;
/** sets directly the value without a ramp */
static const am_CustomRampType_t RAMP_GENIVI_DIRECT = 1;
/** Sets the volume as fast as possible */
static const am_CustomRampType_t RAMP_GENIVI_NO_PLOP = 2;
/** inverted exponential update, high gradient at the start - soft end */
static const am_CustomRampType_t RAMP_GENIVI_EXP_INV = 3;
/** continues update of volume */
static const am_CustomRampType_t RAMP_GENIVI_LINEAR = 4;
/** exponential update, soft start - high gradient at the end */
static const am_CustomRampType_t RAMP_GENIVI_EXP = 5;

/**
 * Within genivi only the some example properties are defined.
 * For products these should be changed or extended.
 */
typedef uint16_t am_CustomSoundPropertyType_t;

static const am_CustomSoundPropertyType_t SP_UNKNOWN = 0;
static const am_CustomSoundPropertyType_t SP_SOUND_BASS = 1;
static const am_CustomSoundPropertyType_t SP_SOUND_MIDDLE = 3;
static const am_CustomSoundPropertyType_t SP_SOUND_TREBLE = 5;
static const am_CustomSoundPropertyType_t SP_MAX = 6;

/**
 * Describes the different system properties which are project specific.
 */
typedef uint16_t am_CustomSystemPropertyType_t;

static const am_CustomSystemPropertyType_t   SYP_UNKNOWN = 0;
/** Different beeps can be started with this */
static const am_CustomSystemPropertyType_t   SYP_BEEP = 1;
/** Fader status active */
static const am_CustomSystemPropertyType_t   SYP_FADER_STATUS_ACTIVE = 2;
/** Volume mode for main1 stream */
static const am_CustomSystemPropertyType_t   SYP_VOLMODE_STREAM_MAIN_1 = 3;
/** Volume mode for Mix1 stream */
static const am_CustomSystemPropertyType_t   SYP_VOLMODE_STREAM_MIX_1 = 4;
/** Diagnosis remote control */
static const am_CustomSystemPropertyType_t   SYP_DIAG_REMOTE_CONTROL = 5;
/** System property for service availability status of GAM */
static const am_CustomSystemPropertyType_t   SYP_AM_SRV_STS = 6;
/** System Property to report that HMI is ready and remove MUTE_HMISTARTUP */
static const am_CustomSystemPropertyType_t   SYP_HMISTARTUP_MUTE = 7;
/** System Property to set drive mode for ESE feature */
static const am_CustomSystemPropertyType_t   SYP_ESE_DRIVE_MODE = 8;
/** System Property to update User Mute/DeMute Status */
static const am_CustomSystemPropertyType_t   SYP_USER_MUTE_STATUS = 9;
/** Property to set/get the collection of sound files to be used for UPA/HFP */
static const am_CustomSystemPropertyType_t   SYP_ADAS_UPA_SOUND_COLLECTION = 10;
/** This property can be used to set/get setting Sound */
static const am_CustomSystemPropertyType_t   SYP_ADAS_SETTING_SOUND = 11;
/** This property used to update last tuner entertainment source playing */
static const am_CustomSystemPropertyType_t   SYP_LAST_TUNER_SOURCE = 12;

static const am_CustomSystemPropertyType_t   SYP_MAX = 13;

/*
* System propert values
*/
/**
 * Value for SYP_DIAG_REMOTE_CONTROL
 * @author Vyankatesh VD
 * @created 30-June-2015 04:44:00 pm
 */
#define SYP_DIAG_REMOTE_CONTROL_OFF  ((int16_t) 0)
#define SYP_DIAG_REMOTE_CONTROL_ON   ((int16_t) 1)

/**
 * Value for SYP_USER_MUTE_STATUS
 * @author Vyankatesh VD
 * @created 23-Augus-2016
 */
#define SYP_USER_MUTE_STATUS_OFF  ((int16_t) 0)
#define SYP_USER_MUTE_STATUS_ON   ((int16_t) 1)

/**
 * gives availability status of HMI
 * @author Vyankatesh VD
 * @created 29-May-2015 12:10:00 pm
 */
#define SYP_HMISTARTUP_MUTE_OFF  ((int16_t) 0)
#define SYP_HMISTARTUP_MUTE_ON   ((int16_t) 1)

/*
 * Values for System property 'SYP_ESE_DRIVE_MODE'
 */
#define AM_SYP_ESE_DRIVE_MODE_ECO      ((int16_t) 0)
#define AM_SYP_ESE_DRIVE_MODE_COMFORT    ((int16_t) 1)
#define AM_SYP_ESE_DRIVE_MODE_NORMAL    ((int16_t) 2)
#define AM_SYP_ESE_DRIVE_MODE_DYNAMIC    ((int16_t) 3)
#define AM_SYP_ESE_DRIVE_MODE_PERSO    ((int16_t) 4)

/**
 * SYP_BEEP values
 */
#define AM_SYP_BEEP_ERROR      ((int16_t) 1)
#define AM_SYP_BEEP_ROGER      ((int16_t) 2)
#define AM_SYP_BEEP_WARN      ((int16_t) 3)
#define AM_SYP_BEEP_CLICK      ((int16_t) 4)
#define AM_SYP_BEEP_POI        ((int16_t) 5)
#define AM_SYP_BEEP_SDS_END      ((int16_t) 6)
#define AM_SYP_BEEP_SMS_INCOMING  ((int16_t) 7)
#define AM_SYP_BEEP_SMS_SEND    ((int16_t) 8)
#define AM_SYP_BEEP_URGENT      ((int16_t) 9)
#define AM_SYP_BEEP_SPEED_WARN    ((int16_t) 10)
#define AM_SYP_BEEP_CURVE_WARN    ((int16_t) 11)
#define AM_SYP_BEEP_AVM_OPERATION  ((int16_t) 12)
#define AM_SYP_BEEP_AVM_ERROR    ((int16_t) 13)
#define AM_SYP_BEEP_SPEED_HINT    ((int16_t) 14)
#define AM_SYP_BEEP_CURVE_HINT    ((int16_t) 15)
#define AM_SYP_BEEP_IPA_NOSOUND    ((int16_t) 16)
#define AM_SYP_BEEP_IPA_3      ((int16_t) 17)
#define AM_SYP_BEEP_IPA_7      ((int16_t) 18)
#define AM_SYP_BEEP_IPA_8      ((int16_t) 19)
#define AM_SYP_BEEP_IPA_9      ((int16_t) 20)
#define AM_SYP_BEEP_IPA_10      ((int16_t) 21)
#define AM_SYP_BEEP_IPA_11      ((int16_t) 22)
#define AM_SYP_BEEP_IPA_STOP_SOUND  ((int16_t) 23)
#define AM_SYP_BEEP_SDS_START    ((int16_t) 24)
#define AM_SYP_BEEP_IPA_4      ((int16_t) 25)
#define AM_SYP_BEEP_IPA_5      ((int16_t) 26)
#define AM_SYP_BEEP_IPA_6      ((int16_t) 27)
#define AM_SYP_BEEP_GST_01    ((int16_t) 65)
#define AM_SYP_BEEP_GST_02    ((int16_t) 66)
#define AM_SYP_BEEP_GST_03     ((int16_t) 67)
#define AM_SYP_BEEP_GST_04     ((int16_t) 68)
#define AM_SYP_BEEP_GST_05     ((int16_t) 69)
#define AM_SYP_BEEP_GST_06     ((int16_t) 70)
#define AM_SYP_BEEP_GST_07     ((int16_t) 71)
#define AM_SYP_BEEP_GST_08     ((int16_t) 72)
#define AM_SYP_BEEP_GST_09     ((int16_t) 73)
#define AM_SYP_BEEP_GST_10     ((int16_t) 74)
#define AM_SYP_BEEP_GST_11     ((int16_t) 75)
#define AM_SYP_BEEP_GST_12     ((int16_t) 76)
#define AM_SYP_BEEP_GST_13     ((int16_t) 77)
#define AM_SYP_BEEP_GST_14     ((int16_t) 78)
#define AM_SYP_BEEP_WARN_NOT_DEF  ((int16_t) 255)

/**
 * SYP_FADER_STATUS_ACTIVE values
 */
#define AM_SYP_FADER_STATUS_INACTIVE  ((int16_t) 0)
#define AM_SYP_FADER_STATUS_ACTIVE    ((int16_t) 1)
#define AM_SYP_FADER_STATUS_NOT_DEF    ((int16_t) 255)

/**
 * SYP_VOLMODE_STREAM_MAIN_1 values
 * and
 * SYP_VOLMODE_STREAM_MIX_1 values
 */
#define AM_SYP_VOLMODE_NORMAL                      ((int16_t) 0)
#define AM_SYP_VOLMODE_SETUP_ONVOL                 ((int16_t) 1)
#define AM_SYP_VOLMODE_SETUP_PHONE                 ((int16_t) 2)
#define AM_SYP_VOLMODE_SETUP_TIM                   ((int16_t) 3)
#define AM_SYP_VOLMODE_SETUP_TA                    ((int16_t) 4)
#define AM_SYP_VOLMODE_BEEPVOL                     ((int16_t) 5)
#define AM_SYP_VOLMODE_DIAGVOL                     ((int16_t) 6)
#define AM_SYP_VOLMODE_NAV_ANNOUNCEMENT            ((int16_t) 7)
#define AM_SYP_VOLMODE_SETUP_NAV_VOL               ((int16_t) 8)
#define AM_SYP_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL  ((int16_t) 9)
#define AM_SYP_VOLMODE_PDC_ATTENUATION_SETUP       ((int16_t) 10)
#define AM_SYP_VOLMODE_SETUP_SDS           ((int16_t) 11)
#define AM_SYP_VOLMODE_NOT_DEF             ((int16_t) 255)

/**
 * gives service availability status of GAM
 * @author Vyankatesh VD
 * @created 17-Jan-2014 03:00:00 pm
 */
enum am_ServiceAvailability_e
{
  SYP_AM_SRV_STS_UNKNOWN = 0,
  SYP_AM_SRV_STS_UNAVAILABLE = 1,
  SYP_AM_SRV_STS_AVAILABLE = 2,
  SYP_AM_SRV_STS_MAX
};

enum am_SystemAudioState_e
{
  SYP_AM_SRV_STS_AUDIOSTATE_OFF = 0,
  SYP_AM_SRV_STS_AUDIOSTATE_EMERGENCY = 1,
  SYP_AM_SRV_STS_AUDIOSTATE_NORMAL = 2,
  SYP_AM_SRV_STS_AUDIOSTATE_LIMITED = 3
};
  enum am_HotSink_e
  {
    /**
     * default
     */
    HS_UNKNOWN = 0,
    /**
     * sinkA is active
     */
    HS_SINKA = 1,
    /**
     * sinkB is active
     */
    HS_SINKB = 2,
    /**
     * the crossfader is in the transition state
     */
    HS_INTERMEDIATE = 3,
    HS_MAX
  };

  /**
   * with the help of this enum, sinks and sources can report their availability state
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  enum am_Availability_e
  {
    /**
     * default
     */
    A_UNKNOWN = 0,
    /**
     * The source / sink is available
     */
    A_AVAILABLE = 1,
    /**
     * the source / sink is not available
     */
    A_UNAVAILABLE = 2,
    A_MAX
  };

/**
 * represents the connection state
 */
  enum am_ConnectionState_e
  {
    CS_UNKNOWN = 0,
    /**
     * This means the connection is just building up
     */
    CS_CONNECTING = 1,
    /**
     * the connection is ready to be used
     */
    CS_CONNECTED = 2,
    /**
     * the connection is in the course to be knocked down
     */
    CS_DISCONNECTING = 3,
    /**
     * only relevant for connectionStatechanged. Is send after the connection was removed
     */
    CS_DISCONNECTED = 4,
    /**
     * this means the connection is still build up but unused at the moment
     */
    CS_SUSPENDED = 5,
    CS_MAX
  };

  enum am_DomainState_e
  {
    /**
     * default
     */
    DS_UNKNOWN = 0,
    /**
     * the domain is controlled by the daemon
     */
    DS_CONTROLLED = 1,
    /**
     * the domain is independent starting up
     */
  DS_INDEPENDENT_STARTUP = 2,
    /**
     * the domain is independent running down
     */
  DS_INDEPENDENT_RUNDOWN = 3,
    DS_MAX
  };

/**
 * This enum characterizes the data of the EarlyData_t
 */
  enum am_EarlyDataType_e
  {
    /**
     * default
     */
    ES_UNKNOWN = 0,
    /**
     * the source volume
     */
    ED_SOURCE_VOLUME = 1,
    /**
     * the sink volume
     */
    ED_SINK_VOLUME = 2,
    /**
     * a source property
     */
    ED_SOURCE_PROPERTY = 3,
    /**
     * a sink property
     */
    ED_SINK_PROPERTY = 4,
  /**
   * The interrupt state
   */
  ED_INTERRUPT_STATE = 5,
    ED_MAX
  };

/**
 * the errors of the audiomanager. All possible errors are in here. This enum is
 * used widely as return parameter.
 */
  enum am_Error_e
  {
    /**
     * no error - positive reply
     */
    E_OK = 0,
    /**
     * default
     */
    E_UNKNOWN = 1,
    /**
     * value out of range
     */
    E_OUT_OF_RANGE = 2,
    /**
     * not used
     */
    E_NOT_USED = 3,
    /**
     * a database error occurred
     */
    E_DATABASE_ERROR = 4,
    /**
     * the desired object already exists
     */
    E_ALREADY_EXISTS = 5,
    /**
     * there is no change
     */
    E_NO_CHANGE = 6,
    /**
     * the desired action is not possible
     */
    E_NOT_POSSIBLE = 7,
    /**
     * the desired object is non existent
     */
    E_NON_EXISTENT = 8,
    /**
     * the asynchronous action was aborted
     */
    E_ABORTED = 9,
    /**
     * This error is returned in case a connect is issued with a connectionFormat that cannot be selected for the connection.
     * This could be either due to the capabilities of a source or a sink or gateway compatibilities for example
     */
    E_WRONG_FORMAT = 10,
    E_MAX
  };

  enum am_MuteState_e
  {
    /**
     * default
     */
    MS_UNKNOWN = 0,
    /**
     * the source / sink is muted
     */
    MS_MUTED = 1,
    /**
     * the source / sink is unmuted
     */
    MS_UNMUTED = 2,
    MS_MAX
  };

/**
 * The source state reflects the state of the source
 */
  enum am_SourceState_e
  {
    SS_UNKNNOWN = 0,
    /**
     * The source can be activly heared
     */
    SS_ON = 1,
    /**
     * The source cannot be heared
     */
    SS_OFF = 2,
    /**
     * The source is paused. Meaning it cannot be heared but should be prepared to play again soon.
     */
    SS_PAUSED = 3,
    SS_MAX
  };

  /**
   * This enumeration is used to define the type of the action that is correlated to a handle.
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  enum am_Handle_e
  {
    H_UNKNOWN = 0,
    H_CONNECT = 1,
    H_DISCONNECT = 2,
    H_SETSOURCESTATE = 3,
    H_SETSINKVOLUME = 4,
    H_SETSOURCEVOLUME = 5,
    H_SETSINKSOUNDPROPERTY = 6,
    H_SETSOURCESOUNDPROPERTY = 7,
    H_SETSINKSOUNDPROPERTIES = 8,
    H_SETSOURCESOUNDPROPERTIES = 9,
    H_CROSSFADE = 10,
    H_SETVOLUMES = 11,
    H_SETSINKNOTIFICATION = 12,
    H_SETSOURCENOTIFICATION = 13,
    H_MAX
  };

  enum am_InterruptState_e
  {
    /**
     * default
     */
    IS_UNKNOWN = 0,
    /**
     * the interrupt state is off - no interrupt
     */
    IS_OFF = 1,
    /**
     * the interrupt state is interrupted - the interrupt is active
     */
    IS_INTERRUPTED = 2,
    IS_MAX
  };

/**
 * This datatype determines if a sourceID or a sinkID is used in the union
 * following
 */
  enum am_VolumeType_e
  {
    VT_UNKNOWN = 0,
    /**
     * the following type is a sink
     */
    VT_SINK = 1,
    /**
     * the following type is a source
     */
    VT_SOURCE = 2,
    VT_MAX
  };

  enum am_NotificationStatus_e
  {
    NS_UNKNOWN = 0,
    /**
     * No notification, the function is turned off
     */
    NS_OFF = 1,
    /**
     * Periodic notifications are sent out. The period in ms is given by am_NotificationParameter
     */
    NS_PERIODIC = 2,
    /**
     * The notification is sent out when the minimum given by am_NotificationParameter is reached.
     */
    NS_MINIMUM = 3,
    /**
     * The notification is sent out when the maximum given by am_NotificationParameter is reached.
     */
    NS_MAXIMUM = 4,
    /**
     * The notification is sent out when a change happened. The Resolution of the change is defined by
     * am_NotificationParameter.
     */
    NS_CHANGE  = 5,
    NS_MAX
  };

  /**
   * this describes the availability of a sink or a source together with the latest change
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  struct am_Availability_s
  {

  public:
    /**
     * the current availability state
     */
    am_Availability_e availability;
    /**
     * the reason for the last change. This can be used to trigger events that deal with state changes.
     */
  am_CustomAvailabilityReason_t availabilityReason;

  };

/**
 * describes class properties
 */
  struct am_ClassProperty_s
  {

  public:
    /**
     * the property as enum
     */
  am_CustomClassProperty_t classProperty;
    /**
     * the value of the property
     */
    int16_t value;

  };

  /**
   * This struct describes the attribiutes of a crossfader.
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  struct am_Crossfader_s
  {

  public:
    /**
     * This is the ID of the crossfader, it is unique in the system. There are 2 ways, ID can be created: either it is
     * assigned during the registration process (in a dynamic context, uniqueness will be ensured by the AudioManager daemon),
     * or it is a fixed (the project has to ensure the uniqueness of the ID).
     */
    am_crossfaderID_t crossfaderID;
    /**
     * The name of the crossfader. Must be unique in the whole system.
     */
    std::string name;
    /**
     * The sinkID of the SinkA. Sinks shall be registered before registering the crossfader.
     */
    am_sinkID_t sinkID_A;
    /**
     * The sinkID of the SinkB. Sinks shall be registered before registering the crossfader.
     */
    am_sinkID_t sinkID_B;
    /**
     * The sourceID of the crossfader source. The source shall be registered before the crossfader.
     */
    am_sourceID_t sourceID;
    /**
     * This enum can have 3 states:
     *
     *    HS_SINKA sinkA is the current hot one, sinkB is not audible
     *    HS_SINKB sinkB is the current hot one, sinkB is not audible
     *    HS_INTERMEDIATE the fader is stuck in between a cross-fading action. This could be due to an abort or an error.
     * Before using the crossfader, it must be set to either HS_SINKA or HS_SINKB.
     */
    am_HotSink_e hotSink;

  };

/**
 * This struct describes the attributes of a converter.
 */
struct am_Converter_s
{

public:
  /**
   * This is the ID of the converter, it is unique in the system. There are 2 ways,
   * ID can be created: either it is assigned during the registration process (in a
   * dynamic context, uniqueness will be ensured by the AudioManagerDaemon), or it
   * is a fixed (the project has to ensure the uniqueness of the ID).
   */
  am_converterID_t converterID;
  /**
   * The name of the converter. Must be unique in the whole system.
   */
  std::string name;
  /**
   * The sinkID of the convertersink-end. The sink is a full blown sink with
   * connectionFormats, sinkClassIDs etc... It makes sense to register the sinks of
   * a gateway as non-visible. Care needs to be taken that the connectionsFormats
   * match with the ones in the conversionMatrix. If the sink is located in the
   * controllingDomain, the ID needs to be retrieved by registering the sink before
   * registering the gateway. In case the sink is in a different domain, the ID
   * needs to be retrieved via peeking.
   */
  am_sinkID_t sinkID;
  /**
   * The sourceID of the converter sink-end. The sink is a full blown source with
   * connectionFormats, sinkClassIDs etc... It makes sense to register the sources
   * of a gateway as non-visible. Care needs to be taken that the connectionsFormats
   * match with the ones in the conversionMatrix. If the source is located in the
   * controllingDomain, the ID needs to be retrieved by registering the source
   * before registering the gateway. In case the source is in a different domain,
   * the ID needs to be retrieved via peeking.
   */
  am_sourceID_t sourceID;
  /**
   * This is the ID of the domain that registers the converter.
   */
  am_domainID_t domainID;
  /**
   * This is the list of available formats on the source side of the converter. It
   * is not defined during the gateway registration but copied from the source
   * registration.
   */
  std::vector<am_CustomConnectionFormat_t> listSourceFormats;
  /**
   * This is the list of available formats on the sink side of the gateway. It is
   * not defined during the converter registration but copied from the sink
   * registration.
   */
  std::vector<am_CustomConnectionFormat_t> listSinkFormats;
  /**
   * This is matrix holding information about the conversion capability of the
   * converter, it's length is defined by the length(listSinkFormats) x
   * length(listSourceFormats).
   * If a SinkFormat can be converted into a SourceFormat, the vector will hold a 1,
   * if no conversion is possible, a 0.
   * The data is stored row orientated, where the rows are related to the
   * sinksFormats and the columns to the sourceFormats. The first value will hold
   * the conversion information from the first sourceFormat to the first sinkFormat
   * for example and the seventh value the information about the 3rd sinkFormat to
   * the 1st sourceFormat in case we would have 3 sourceFormats.
   *
   * This matrix
   * 110 011 000 111 001
   *
   * reads as this:
   *          Source
   *   **  1  2  3
   * *********************
   * S  1*  1  1  0
   * i  2*  0  1  1
   * n  3*  0  0  0
   * k  4*  1  1  1
   *   5*  0  0  1
   */
  std::vector<bool> convertionMatrix;
};

  struct am_Gateway_s
  {

  public:
    /**
     * This is the ID of the gateway, it is unique in the system. There are 2 ways, ID can be created: either it is assigned
     * during the registration process (in a dynamic context, uniqueness will be ensured by the AudioManagerDaemon), or it is
     * a fixed (the project has to ensure the uniqueness of the ID).
     */
    am_gatewayID_t gatewayID;
    /**
     * The name of the gateway. Must be unique in the whole system.
     */
    std::string name;
    /**
     * The sinkID of the gateway sink-end. The sink is a full blown sink with connectionFormats, sinkClassIDs etc... It makes
     * sense to register the sinks of a gateway as non-visible. Care needs to be taken that the connectionsFormats match with
     * the ones in the conversionMatrix. If the sink is located in the controllingDomain, the ID needs to be retrieved by
     * registering the sink before registering the gateway. In case the sink is in a different domain, the ID needs to be
     * retrieved via peeking.
     */
    am_sinkID_t sinkID;
    /**
     * The sourceID of the gateway sink-end. The sink is a full blown source with connectionFormats, sinkClassIDs etc... It
     * makes sense to register the sources of a gateway as non-visible. Care needs to be taken that the connectionsFormats
     * match with the ones in the conversionMatrix. If the source is located in the controllingDomain, the ID needs to be
     * retrieved by registering the source before registering the gateway. In case the source is in a different domain, the ID
     * needs to be retrieved via peeking.
     */
    am_sourceID_t sourceID;
    /**
     * The ID of the sink. If the domain is the same like the controlling domain, the ID is known due to registration. If the
     * domain is different, the ID needs to be retrieved via peeking.
     */
    am_domainID_t domainSinkID;
    /**
     * The ID of the source. If the domain is the same like the controlling domain, the ID is known due to registration. If
     * the domain is different, the ID needs to be retrieved via peeking.
     */
    am_domainID_t domainSourceID;
    /**
     * This is the ID of the domain that registers the gateway.
     */
    am_domainID_t controlDomainID;
    /**
     * This is the list of available formats on the source side of the gateway. It is not defined during the gateway
     * registration but copied from the source registration.
     */
  std::vector<am_CustomConnectionFormat_t> listSourceFormats;
    /**
     * This is the list of available formats on the sink side of the gateway. It is not defined during the gateway
     * registration but copied from the sink registration.
     */
  std::vector<am_CustomConnectionFormat_t> listSinkFormats;
    /**
     * This is matrix holding information about the conversion capability of the gateway, it's length is defined by the
     * length(listSinkFormats) x length(listSourceFormats).
     * If a SinkFormat can be converted into a SourceFormat, the vector will hold a 1, if no conversion is possible, a 0.
     * The data is stored row orientated, where the rows are related to the sinksFormats and the columns to the sourceFormats.
     * The first value will hold the conversion information from the first sourceFormat to the first sinkFormat for example
     * and the seventh value the information about the 3rd sinkFormat to the 1st sourceFormat in case we would have 3
     * sourceFormats.
     *
     * This matrix
     * 110 011 000 111 001
     *
     * reads as this:
     *          Source
     *   **  1  2  3
     * *********************
     * S  1*  1  1  0
     * i  2*  0  1  1
     * n  3*  0  0  0
     * k  4*  1  1  1
     *   5*  0  0  1
     */
    std::vector<bool> convertionMatrix;

  };

/**
 * This represents one "hopp" in a route
 */
  struct am_RoutingElement_s
  {

  public:
    /**
     * the source ID
     */
    am_sourceID_t sourceID;
    /**
     * the sinkID
     */
    am_sinkID_t sinkID;
    /**
     * the domainID the routeElement is in
     */
    am_domainID_t domainID;
    /**
     * the connectionformat that is used for the route
     */
  am_CustomConnectionFormat_t connectionFormat;

  };

  /**
   * a list of routing elements that lead from source to sink
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  struct am_Route_s
  {

  public:
    /**
     * the sourceID where the route starts
     */
    am_sourceID_t sourceID;
    /**
     * the sinkID where the route ends
     */
    am_sinkID_t sinkID;
    /**
     * the actual route as list of routing elements
     */
    std::vector<am_RoutingElement_s> route;

  };

/**
 * struct describing the sound property
 */
  struct am_SoundProperty_s
  {

  public:
    /**
     * the type of the property - a project specific enum
     */
  am_CustomSoundPropertyType_t type;
    /**
     * the actual value of the property
     */
    int16_t value;

  };

  /**
   * struct describing system properties
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  struct am_SystemProperty_s
  {

  public:
    /**
     * the type that is set
     */
  am_CustomSystemPropertyType_t type;
    /**
     * the value
     */
    int16_t value;

  };

  /**
   * struct describing sinkclasses
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:22
   */
  struct am_SinkClass_s
  {

  public:
    /**
     * the ID of the sinkClass
     */
    am_sinkClass_t sinkClassID;
    /**
     * the name of the sinkClass - must be unique in the system
     */
    std::string name;
    /**
     * the list of the class properties. These are pairs of  a project specific enum describing the type of the value and an
     * integer holding the real value.
     */
    std::vector<am_ClassProperty_s> listClassProperties;

  };

/**
 * struct describing source classes
 */
  struct am_SourceClass_s
  {

  public:
    /**
     * the source ID
     */
    am_sourceClass_t sourceClassID;
    /**
     * the name of the sourceClass - must be unique in the system
     */
    std::string name;
    /**
     * the list of the class properties. These are pairs of  a project specific enum describing the type of the value and an
     * integer holding the real value.
     */
    std::vector<am_ClassProperty_s> listClassProperties;

  };

/**
 * this type holds all information of sources relevant to the HMI
 */
  struct am_SourceType_s
  {

  public:
    /**
     * This is the ID of the source, it is unique in the system. There are 2 ways, ID can be created: either it is assigned
     * during the registration process (in a dynamic context, uniqueness will be ensured by the AudioManagerDaemon), or it is
     * a fixed (the project has to ensure the uniqueness of the ID).
     */
    am_sourceID_t sourceID;
    /**
     * The name of the source. Must be unique in the whole system.
     */
    std::string name;
    /**
     * the availability of the source
     */
    am_Availability_s availability;
  /**
   * the sourceClassID, indicates the class the source is in. This information can
   * be used by the Controller to implement different behaviour for different
   * classes.
   */
    am_sourceClass_t sourceClassID;

  };

  /**
   * this type holds all information of sinks relevant to the HMI
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  struct am_SinkType_s
  {

  public:
    /**
     * This is the ID of the sink, it is unique in the system. There are 2 ways, ID can be created: either it is assigned
     * during the registration process (in a dynamic context, uniqueness will be ensured by the AudioManagerDaemon), or it is
     * a fixed (the project has to ensure the uniqueness of the ID).
     */
    am_sinkID_t sinkID;
    /**
     * The name of the sink. Must be unique in the whole system.
     */
    std::string name;
    /**
     * This attribute reflects the availability of the sink. There are several reasons why a sink could be not available for
     * the moment: for example the shutdown of a sink because of overtemperature or over- & undervoltage. The availability
     * consists of two pieces of information:
     *
     *    Availablility: the status itself, can be A_AVAILABLE, A_UNAVAILABLE or A_UNKNOWN
     *    AvailabilityReason: this informs about the last reason for a change in availability. The reasons itself are product
     * specific.
     */
    am_Availability_s availability;
    /**
     * This is the representation of the Volume for the commandInterface. It is used by the HMI to set the volume of a sink,
     * the AudioManagerController has to transform this into real source and sink volumes.
     */
    am_mainVolume_t volume;
    am_MuteState_e muteState;
    /**
     * The sinkClassID references to a sinkClass. With the help of classification, rules can be setup to define the system
     * behaviour.
     */
    am_sinkClass_t sinkClassID;

  };

  /**
   * a handle is used for asynchronous operations and is uniquely assigned for each of this operations
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  struct am_Handle_s
  {

  public:
    /**
     * the handletype
     */
    am_Handle_e handleType:6;
    /**
     * the handle as value
     */
    uint16_t handle:10;

  };

  /**
   * struct describung mainsound property
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  struct am_MainSoundProperty_s
  {

  public:
    /**
     * the type of the property
     */
  am_CustomMainSoundPropertyType_t type;
    /**
     * the actual value
     */
    int16_t value;

  };

/**
 * this type holds all information of connections relevant to the HMI
 */
  struct am_MainConnectionType_s
  {

  public:
    /**
     * the ID of the mainconnection
     */
    am_mainConnectionID_t mainConnectionID;
    /**
     * the sourceID where the connection starts
     */
    am_sourceID_t sourceID;
    /**
     * the sinkID where the connection ends
     */
    am_sinkID_t sinkID;
    /**
     * the delay of the mainconnection
     */
    am_timeSync_t delay;
    /**
     * the current connection state
     */
    am_ConnectionState_e connectionState;

  };

/**
 * struct that holds attribiutes of a mainconnection
 */
  struct am_MainConnection_s
  {

  public:
    /**
     * the assigned ID
     */
    am_mainConnectionID_t mainConnectionID;
    /**
     * the current connection state
     */
    am_ConnectionState_e connectionState;
    /**
     * the sinkID
     */
    am_sinkID_t sinkID;
    /**
     * the sourceID
     */
    am_sourceID_t sourceID;
    /**
     * the delay of the connection
     */
    am_timeSync_t delay;
    /**
     * the list of sub connection IDs the mainconnection consists of
     */
    std::vector<am_connectionID_t> listConnectionID;

  };

  /**
   * This struct holds the payload of a notification.
   * @author q232968
   * @version 1.0
   * @created 17-Jan-2013 10:00:23
   */
  struct am_NotificationPayload_s
  {

  public:
    /**
     * This defines the notification type
     */
  am_CustomNotificationType_t type;
    /**
     * This is finally the value of the notification. It's meaning depends on the notificationType
     */
    int16_t value;

  };

  /**
   * This struct holds information about the configuration for notifications
   * @author q232968
   * @version 1.0
   * @created 17-Jan-2013 10:00:23
   */
  struct am_NotificationConfiguration_s
  {

  public:
    /**
     * The notification type of the notification
     */
  am_CustomNotificationType_t type;
    /**
     * The Notification status. This can be periodic, min/max value based or even off for example
     */
    am_NotificationStatus_e status;
    /**
     * This gives additional information to the notification status.
     * Relation between notification status and the value:
     * NS_PERIODIC - the period in ms
     * NS_MINIMUM - the minimum value that triggers the notification
     * NS_MAXIMUM - the maximum value that triggers the notifcation
     * NS_CHANGE - the resolution of the change value
     */
    int16_t parameter;

  };

/**
 * This struct describes the attribiutes of a sink
 */
  struct am_Sink_s
  {

  public:
    /**
     * This is the ID of the sink, it is unique in the system. There are 2 ways, ID can be created: either it is assigned
     * during the registration process (in a dynamic context, uniqueness will be ensured by the AudioManagerDaemon), or it is
     * a fixed (the project has to ensure the uniqueness of the ID).
     */
    am_sinkID_t sinkID;
    /**
     * The name of the sink. Must be unique in the whole system.
     */
    std::string name;
    /**
     * The domainID is the domain the sink belongs to. A sink can only be in one domain.
     */
    am_domainID_t domainID;
    /**
     * The sinkClassID references to a sinkClass. With the help of classification, rules can be setup to define the system
     * behaviour.
     */
    am_sinkClass_t sinkClassID;
    /**
     * This is the volume of the sink. It is set by the AudioManagerController.
     */
    am_volume_t volume;
    /**
     * This Boolean flag indicates whether a sink is visible to the commandInterface or not. If the User must have the
     * possibility to choose the source in the HMI, it must be visible. But there are also good reasons for invisible sinks,
     * for example if the sink is part of a crossfader or gateway. HMI relevant changes in visible sinks will be automatically
     * reported by the daemon to the commandInterface.
     */
    bool visible;
    /**
     * This attribute reflects the availability of the sink. There are several reasons why a sink could be not available for
     * the moment: for example the shutdown of a sink because of overtemperature or over- & undervoltage. The availability
     * consists of two pieces of information:
     *
     *    Availablility: the status itself, can be A_AVAILABLE, A_UNAVAILABLE or A_UNKNOWN
     *    AvailabilityReason: this informs about the last reason for a change in availability. The reasons itself are product
     * specific.
     */
    am_Availability_s available;
    /**
     * This attribute reflects the muteState of the sink. The information is not the "real" state of the sink, but the HMI
     * representation for he commandInterface controlled by the AudioManagerController.
     */
    am_MuteState_e muteState;
    /**
     * This is the representation of the Volume for the commandInterface. It is used by the HMI to set the volume of a sink,
     * the AudioManagerController has to transform this into real source and sink volumes.
     */
    am_mainVolume_t mainVolume;
    /**
     * This is the list of soundProperties, that the sink is capable of. The soundProperties itself are project specific. For
     * sinks, a possible soundProperty could be for example settings.
     */
    std::vector<am_SoundProperty_s> listSoundProperties;
    /**
     * This list holds information about the formats that the Source is capable of supporting when delivering audio.
     */
  std::vector<am_CustomConnectionFormat_t> listConnectionFormats;
    /**
     * This is the list of the available mainSoundProperties. The principle is the same than with soundProperties, but they
     * are only visible to the CommandInterface.
     */
    std::vector<am_MainSoundProperty_s> listMainSoundProperties;
    /**
     * This is the list of the MainNotificationConfigurations. These notifications work on the level of command interface.
     */
    std::vector<am_NotificationConfiguration_s> listMainNotificationConfigurations;
    /**
     * This is the list of the NotificationConfigurations. These notifications work on the level of RoutingPlugins.
     */
    std::vector<am_NotificationConfiguration_s> listNotificationConfigurations;

  };

  /**
   * This struct describes the attribiutes of a source
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  struct am_Source_s
  {

  public:
    /**
     * This is the ID of the source, it is unique in the system. There are 2 ways, ID can be created: either it is assigned
     * during the registration process (in a dynamic context, uniqueness will be ensured by the AudioManagerDaemon), or it is
     * a fixed (the project has to ensure the uniqueness of the ID).
     */
    am_sourceID_t sourceID;
    /**
     * The domainID is the domain the source belongs to. A source can only be in one domain.
     */
    am_domainID_t domainID;
    /**
     * The name of the source. Must be unique in the whole system.
     */
    std::string name;
    /**
     * the sourceClassID, indicates the class the source is in. This information can be used by the Controller to implement
     * different behaviour for different classes.
     */
    am_sourceClass_t sourceClassID;
    /**
     * The source state is an indication towards the source if it is actively heard or not. The source can use this
     * information to implement features like automatic spin down of CD's in case the CD is not the active source or AF
     * following of a tuner that is not actively heard. The source state is set by the AudioManagerController.There are 3
     * possible states:
     *
     *    SS_ON: the source is active
     *    SS_OFF: the source is off
     *    SS_PAUSED: the source is paused and not active.
     */
    am_SourceState_e sourceState;
    /**
     * This is the volume of the source. It is set by the AudioManagerController. It is used to adopt different audiolevels in
     * a system and mixing of sources (e.g. navigation hints & music).
     */
    am_volume_t volume;
    /**
     * This Boolean flag indicates whether a source is visible to the commandInterface or not. If the User must have the
     * possibility to choose the source in the HMI, it must be visible. But there are also good reasons for invisible sources,
     * for example if the source is part of a crossfader or gateway. HMI relevant changes in visible sources will be
     * automatically reported by the daemon to the commandInterface.
     */
    bool visible;
    /**
     * This attribute reflects the availability of the source. There are several reasons why a source could be not available
     * for the moment. For example a CD player which has no CD entered in the slot can be unavailable, or a USB player with no
     * or unreadable stick attached. Other scenarios involve the shutdown of a source because of overtemperature or over- &
     * undervoltage. The availability consists of two informations:
     *
     *    Availablility: the status itself, can be A_AVAILABLE, A_UNAVAILABLE or A_UNKNOWN
     *    AvailabilityReason: this informs about the last reason for a change in availability. The reasons itself are product
     * specific.
     */
    am_Availability_s available;
    /**
     * Some special sources can have special behaviors, the are so called "Low Level Interrupts". Here the current status is
     * documented. The information can be used by the AudioManagerController to react to the changes by for example lowering
     * the volume of the mainSources. The two states are
     *
     *    IS_OFF: the interrupt is not active at the moment
     *    IS_INTERRUPTED: the interrupt is playing at the moment.
     */
    am_InterruptState_e interruptState;
    /**
     * This is the list of soundProperties, that the source is capable of. The soundProperties itself are project specific.
     * For sources, a possible soundProperty could be navigation volume offset, for example.
     */
    std::vector<am_SoundProperty_s> listSoundProperties;
    /**
     * This list holds information about the formats that the Source is capable of supporting when delivering audio.
     */
  std::vector<am_CustomConnectionFormat_t> listConnectionFormats;
    /**
     * This is the list of the available mainSoundProperties. The principle is the same than with soundProperties, but they
     * are only visible to the CommandInterface.
     */
    std::vector<am_MainSoundProperty_s> listMainSoundProperties;
    /**
     * The list of MainNotificationConfigurations. These notifications work on the level of CommandInterface.
     */
    std::vector<am_NotificationConfiguration_s> listMainNotificationConfigurations;
    /**
     * The list of MainNotificationConfigurations. These notifications work on the level of RoutingInterface.
     */
    std::vector<am_NotificationConfiguration_s> listNotificationConfigurations;

  };

  /**
   * This struct describes the attribiutes of a domain
   * @created 17-Jan-2013 10:00:23
   */
  struct am_Domain_s
  {

  public:
    /**
     * the domain ID
     */
    am_domainID_t domainID;
    /**
     * the name of the domain
     */
    std::string name;
    /**
     * the busname. This is equal to a plugin name and is used to dispatch messages to the elements of a plugin
     */
    std::string busname;
    /**
     * the name of the node
     */
    std::string nodename;
    /**
     * indicated if the domain is independent at startup or not
     */
    bool early;
    /**
     * indicates if the domain registration is complete or not
     */
    bool complete;
    /**
     * the current domain state
     */
    am_DomainState_e state;

  };

  /**
   * a connection
   * @created 17-Jan-2013 10:00:23
   */
  struct am_Connection_s
  {

  public:
    /**
     * the assigned ID
     */
    am_connectionID_t connectionID;
    /**
     * the source the audio flows from
     */
    am_sourceID_t sourceID;
    /**
     * the sink the audio flows to
     */
    am_sinkID_t sinkID;
    /**
     * the delay of the conneciton
     */
    am_timeSync_t delay;
    /**
     * the used connectionformat
     */
  am_CustomConnectionFormat_t connectionFormat;

  };

  /**
   * data type depends of am_EarlyDataType_e:
   * volume_t in case of ED_SOURCE_VOLUME, ED_SINK_VOLUME
   * soundProperty_t in case of ED_SOURCE_PROPERTY, ED_SINK_PROPERTY
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  union am_EarlyData_u
  {

  public:
    am_volume_t volume;
    am_SoundProperty_s soundProperty;
  am_InterruptState_e interruptState;

  };

  /**
   * data type depends of am_EarlyDataType_e:
   * sourceID in case of ED_SOURCE_VOLUME, ED_SOURCE_PROPERTY
   * sinkID in case of ED_SINK_VOLUME, ED_SINK_PROPERTY
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  union am_DataType_u
  {

  public:
    am_sinkID_t sink;
    am_sourceID_t source;

  };

  /**
   * @author Christian Mueller
   * @created 17-Jan-2013 10:00:23
   */
  struct am_EarlyData_s
  {

  public:
    am_EarlyDataType_e type;
    am_DataType_u sinksource;
    am_EarlyData_u data;

  };

  /**
   * This types describe a mixed description for source and sinks volumes.
   * @author q232968
   * @version 1.0
   * @created 17-Jan-2013 10:00:24
   */
  struct am_Volumes_s
  {

  public:
    /**
     * describes the type of the volume: source or sink.
     */
    am_VolumeType_e volumeType;
    /**
     * either sourceID or sinkID
     */
    am_DataType_u volumeID;
    /**
     * The volume
     */
    am_volume_t volume;
    /**
     * the ramp that shall be driven
     */
  am_CustomRampType_t ramp;
    /**
     * the time for the ramp
     */
    am_time_t time;

  };
}
#endif // !defined(EA_E6597B7D_75F2_4586_A193_B3C4EA5C6548__INCLUDED_)

